<?php 


//include 'services/session.php';
include 'includes/dbconn.php'; // Make sure to create this file to handle the database connection.

$_SESSION['error'] = null;

// Assuming the form method is POST and the form fields for email and password are 'email' and 'password' respectively.
if (isset($_POST['email']) && isset($_POST['password'])) {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    if (empty($email) || empty($password)) {
        $_SESSION['error'] = "Please enter both email and password.";
    } else {
        if (checkAuth($email, $password)) {
            // Authentication successful, redirect to appropriate dashboard based on role
            $role = $_SESSION['role']; // The role is set in the session during authentication

            switch ($role) {
                case 'admin':
                    header('Location: admin_dashboard.php');
                    exit;
                case 'manager':
                    header('Location: manager_dashboard.php');
                    exit;
                case 'employee':
                    header('Location: employee_dashboard.php');
                    exit;
                default:
                    // If role is not defined or is something else, redirect to a default page
                    header('Location: default_dashboard.php');
                    exit;
            }
        } else {
            // Authentication failed
            $_SESSION['error'] = "Email or password is incorrect.";
        }
    }
}

function checkAuth($email, $password) {
    // Use the database connection to retrieve user info
    $dbService = DatabaseService::getInstance();
    $user = $dbService->getUserByEmail($email);

    if ($user && password_verify($password, $user['password_hash'])) {
        // Password is correct, set the session variables
        setSession($user['user_id'], $user['email'], $user['role']);
        return true;
    } else {
        return false;
    }
}

function setSession($userId, $email, $role) {
    $_SESSION['user_id'] = $userId;
    $_SESSION['email'] = $email;
    $_SESSION['role'] = $role;
    $_SESSION['loggedin'] = true;
}

function logoutSession() {
    // Destroy the session
    $_SESSION = array();
    session_destroy();
}
?>